local mods

return Def.ActorFrame {
	InitCommand = function(self)
	end,

	OnCommand = function(self)
		local screen = SCREENMAN:GetTopScreen()

		local null = self:GetChild('NullActorFrame')

		local p1 = screen:GetChild('PlayerP1')
		local p2 = screen:GetChild('PlayerP2') or null

		if not p1 then
			for i,v in pairs(screen:GetChild('')) do
				if tostring(v):find('Player') then
					p1 = v
					break
				end
			end
		end

		local players = {p1, p2}

		local p1state = GAMESTATE:GetPlayerState(PLAYER_1)
		local p2state = GAMESTATE:GetPlayerState(PLAYER_2)

		local section1 = '*20 boost'
		local section1Off = '*20 no boost'

		local theBeginning = '1.75x,*99 no mini,*99 overhead,*99 no reverse'

		local section2Off = '*99 no stealth,*99 no invert,*99 no flip'
		local section2 = '*99 50% stealth,*99 no invert,*99 no flip'
		
		local sectionToo = '*99 no stealth,*99 invert,*99 no flip'
		local sectionTwo = '*99 50% stealth,*99 -100% invert,*99 flip'

		local goDown = '*3 200% centered'
		local restorePosition = '*99 no centered'

		mods = {
			{0, theBeginning},
			{478, restorePosition}
		}
		
for beat=0,191, 1 do
	table.insert(mods, {beat, section1})
	table.insert(mods, {beat + 0.125, section1Off})
	table.insert(mods, {beat + 0.25, section1})
	table.insert(mods, {beat + 0.375, section1Off})
	table.insert(mods, {beat + 0.5, section1})
	table.insert(mods, {beat + 0.625, section1Off})
	table.insert(mods, {beat + 0.75, section1})
	table.insert(mods, {beat + 0.875, section1Off})
end
		
for beat=448,477, 2 do
	table.insert(mods, {beat + 0.25, goDown})
	table.insert(mods, {beat, restorePosition})
end

rundum={{192,255},{256, 259},{262, 262.5},{264, 267},{270,270.5},{272, 276},{278, 278.5},{280, 283},{286, 286.5},{288,291},{294, 294.5},{296, 299},{302, 302.5},{304, 307},{310, 310.5},{312, 315},{318, 318.5},{320, 323},{326, 326.5},{328, 331},{334, 334.5},{337, 339},{342, 342.5},{344, 347},{350, 350.5},{352, 355},{358, 358.5},{360, 363}--[[360 NOSCOPED!]],{366, 366.5},{368, 371},{374, 374.5},{376, 379},{382, 382.5},{384, 386.5},{392, 392.5},{394, 394.5},{400, 400.5},{402, 402.5},{408, 408.5},{410, 410.5},{416, 420}--[[420 BLAZIT!]],{422, 422.5},{424, 427},{430, 430.5},{432, 435},{438, 438.5},{440, 443},{446, 446.5}}

for i,v in pairs(rundum) do
    for beat=v[1],v[2], 0.6 do
        table.insert(mods, {beat, section2})
		table.insert(mods, {beat + 0.167, sectionToo})
		table.insert(mods, {beat + 0.333, sectionTwo})
		table.insert(mods, {beat + 0.5, section2Off})
		table.insert(mods, {beat + 0.667, section2})
		table.insert(mods, {beat + 0.833, sectionToo})
		table.insert(mods, {beat + 2, section2Off})
    end
end




		p1:stopeffect()
		p2:stopeffect()

		local firstRun = true
		self:SetUpdateFunction(function(self, delta)
			local currentBeat = GAMESTATE:GetSongBeat()

			for i=1, #mods do
				local mod = mods[i]
				if not mod.done and currentBeat >= mod[1] then
					local modstr = table.concat({ unpack(mod, 2) }, ',')
					p1state:SetPlayerOptions('ModsLevel_Song', p1state:GetPlayerOptionsString('ModsLevel_Song')..','..modstr)
					p2state:SetPlayerOptions('ModsLevel_Song', p2state:GetPlayerOptionsString('ModsLevel_Song')..','..modstr)
					mod.done = true

					-- this is horrible, like, no
					-- only keeping for historical purposes
					-- for modname, values in pairs(mod) do
					-- 	if p1options[modname] then
					-- 		p1options[modname](p1options, unpack(values))
					-- 		p2options[modname](p2options, unpack(values))
					-- 	end
					-- end

					if not firstRun then
						break
					end
				end
			end
			

			if firstRun then
				p1:finishtweening()
				p2:finishtweening()
			end
			firstRun = false
		end)
	end,

	Def.Quad{ OnCommand = function(self) self:sleep(1000) end },
	Def.ActorFrame{ Name='NullActorFrame' },
}
